<?php
/**
 * Child Theme functions loads the main theme class and extra options
 *
 * @package SmartBox Child
 * @subpackage Child
 * @since 1.3
 *
 * @copyright (c) 2013 Oxygenna.com
 * @license http://wiki.envato.com/support/legal-terms/licensing-terms/
 * @version 1.0
 */

// load the parent theme class

require_once get_template_directory() . '/inc/core/theme.php';

$theme = new OxyTheme(
    array(
        'theme_name'   => 'SmartBox Child',
        'theme_short'  => 'smartbox_child',
        'text_domain'  => 'smartbox_child_textdomain',
        'min_wp_ver'   => '3.4',
        'option-pages' => array(
            'general',
            'portfolio',
            'blog',
            'flexslider',
            'social',
            'permalinks',
            '404',
            'advanced'
        ),
         'sidebars' => array(
            'sidebar'            => array( 'Main Sidebar', 'Main sidebar for blog and non full width pages' ),
            'above-nav-right'    => array( 'Top right', 'Above Navigation section to the right' ),
            'above-nav-left'     => array( 'Top left', 'Above Navigation section to the left' ),
            'footer-left'        => array( 'Footer left', 'Left footer section' ),
            'footer-right'       => array( 'Footer right', 'Right footer section' ),
        ),
        'widgets' => array(
            'Smartbox_twitter' => 'smartbox_twitter.php',
            'Smartbox_social'  => 'smartbox_social.php',
            'Smartbox_wpml_language_selector'  => 'smartbox_wpml_language_selector.php',
        ),
    )
);

function oxy_load_child_scripts() {
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array('style'), false,'all' );
}
add_action( 'wp_enqueue_scripts', 'oxy_load_child_scripts');
